-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.win = false
    self.def = false
    self.p0 = Citadels.GetPlayer(0)
    
    if not self.loaded then
      self.p0:AddQuest('D10G_GOAL_1','main')
      self.p0:AddQuest('D10_ECONOMY_RAID','side')
      self.p0:AddQuest('D10_SECOND_FORT','side')
    end
  end
  
  if self.win then
    Citadels.SetAchievementDone(15)
    Citadels.ForceVictory()
  end
  
  if self.def then
    Citadels.ForceDefeat()
  end  
end

function OnTrigger(self, source, target)
  if target == "victory" then
    self.win = true
  elseif target == "defeat" then
    self.def = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("victory")
  self:AddTriggerTarget("defeat")
end
